unit EngineImgService02;
(*
   ========================================================================
    " " GraphEngine.
      ,   .
   : BitMap.PixelFormat = pf24bit
   ========================================================================
     :
   1) ........
   2) ........
   ========================================================================
   ()  ,    , , .
   ()   [  ]  ... 
   ========================================================================
*)
interface

uses  //  
      Graphics, ComCtrls, Dialogs, Math,
      //     "ImgTools"
      //   " "
      MainData, EngineMainData01;

// ------------------------------------------------------------------------
//    TImgTabBGR    
//  Angle      ptTargetArray
procedure RotateForTabBGR  (ptSourceArray : ptImgTabBGR;
                            RImgRow       : integer;
                            RImgCol       : integer;
                            RqAngle       : extended;
                            RqColor       : TColor;
                            ptTargetArray : ptImgTabBGR;
                            Progress      : TProgressBar);
// ------------------------------------------------------------------------
//    BGR - 
procedure MirrorToTrgArr  (ptSrcArr : ptImgTabBGR;
                           Cmd      : char;
                           ptTrgArr : ptImgTabBGR;
                           Progress : TProgressBar);
// ------------------------------------------------------------------------
//      90 
procedure Rotate90PlusMinus(ptSrcArr : ptImgTabBGR;
                            Cmd      : char;
                            ptTrgArr : ptImgTabBGR;
                            Progress : TProgressBar);

// ========================================================================
implementation
// ========================================================================

//     TColor
type TSRGB = record
  R : byte;    //   
  G : byte;    //   
  B : byte;    //   
  W : byte;    //  -     Windows
end;

//  BGR-
type TBGR = record
    B : byte;  //  - Blue
    G : byte;  //  - Green
    R : byte;  //  - Red
end;

//       
type TRotateCB = record
  // --------------------
  //   
  // --------------------
  ptSrcBGR : ptImgTabBGR; //  BGR -   
  ptTrgBGR : ptImgTabBGR; //  BGR -   
  Angle    : extended;    //    
  BColor   : TColor;      //    
  // --------------------
  RARow    : integer;     //      BGR - 
  RACol    : integer;
  RGRow    : extended;    //      
  RGCol    : extended;
  // --------------------
  //     
  // --------------------
  SARow    : integer;     //     BGR - 
  SACol    : integer;
  // --------------------
  //     
  // --------------------
  SGRow    : extended;    //     
  SGCol    : extended;
  SXLen    : extended;    //      X
  SYLen    : extended;    //      Y
  // --------------------
  GVLen    : extended;    //     
  SAngl    : extended;    //     
  TAngl    : extended;    //     
  // --------------------
  TXLen    : extended;    //      X
  TYLen    : extended;    //      Y
  TGRow    : extended;    //     
  TGCol    : extended;
  // --------------------
  //       BGR - 
  // --------------------
  TARow    : integer;     //     
  TACol    : integer;
  // --------------------
end;

// ========================================================================
//       
//   BGR-  
// ========================================================================
//   
function DecodeColor (RqColor : TColor) : TBGR;
var BM : TBitMap;
    pBGR : ^TBGR;
begin
  if TSRGB(RqColor).W = 0
  then begin
     //    (  RGB)
     Result.B := TSRGB(RqColor).B;
     Result.G := TSRGB(RqColor).G;
     Result.R := TSRGB(RqColor).R;
  end
  else begin
    //      Windows
    try
     //   BitMap
     BM := TBitMap.Create;
     BM.PixelFormat := pf24bit;
     BM.Width  := 1;
     BM.Height := 1;
     //  Canvas    
     //     Windows
     BM.Canvas.Pixels[0,0]:=RqColor;
     //     BGR
     //       BitMap
     pBGR := BM.ScanLine[0];
     //       BGR
     Result.B := pBGR^.B;
     Result.G := pBGR^.G;
     Result.R := pBGR^.R;
     BM.Free;
    except
      //        Gray
      Result.B := 127;
      Result.G := 127;
      Result.R := 127;
    end;
  end;
end;
// ------------------------------------------------------------------------
//       
function SetAndCrearTabBGR(ptSourceArray : ptImgTabBGR;
                           RqColor       : TColor;
                           ptTargetArray : ptImgTabBGR;
                           Progress      : TProgressBar) : boolean;
var SRow, PMCol, WCol : integer;
    wBGR  : TBGR;
begin
   Result := False;
   //   
   wBGR  := DecodeColor(RqColor);
   //       
   try
     Progress.Min := 0;
     Progress.Max := Length(ptSourceArray^);
     Progress.Position := Progress.Min;
     //    
     SetLength(ptTargetArray^, Length(ptSourceArray^));
     for SRow := 0 to High(ptSourceArray^) do
     begin
        //       
        SetLength(ptTargetArray^[SRow], Length(ptSourceArray^[SRow]));
        PMCol := Length(ptSourceArray^[SRow]);
        WCol := 0;
        while WCol < PMCol
        do begin
           //     ptTargetArray
           ptTargetArray^[SRow, WCol]   := wBGR.B;   // B
           ptTargetArray^[SRow, WCol+1] := wBGR.G;   // G
           ptTargetArray^[SRow, WCol+2] := wBGR.R;   // R
           WCol := WCol + 3;  //  BGR - 
        end;
        Progress.Position := Progress.Position + 1;
     end;
     Result := True;
   except
        SetLength(ptTargetArray^, 0);
        MessageDlg('SetAndCrearTabBGR :    .',
                    mtWarning, [mbOk], 0);
   end;
end;
// ------------------------------------------------------------------------
//   (RARow, RACol)      
procedure RArrToGeomCord (var RotateCB : TRotateCB);
begin
  with RotateCB
  do begin
    //   ,  ( BGR) .
    //      Left, Bottom 
    RGRow := RARow;
    RGCol := (Length(ptTrgBGR^[0])  - RACol) div 3;
  end;
end;
// ------------------------------------------------------------------------
//   (SARow, SACol)      
procedure SArrToGeomCord (var RotateCB : TRotateCB);
begin
  with RotateCB
  do begin
    //   ,  ( BGR) .
    //      Left, Bottom 
    SGRow := SARow;
    SGCol := (Length(ptTrgBGR^[0]) - SACol) div 3;
  end;
end;
// ------------------------------------------------------------------------
//   (TGRow, TGCol)      
procedure GeomToArrCord (var RotateCB : TRotateCB);
begin
  with RotateCB
  do begin
    TARow := Round(TGRow);
    TACol := Round(TGCol);       //   
    TACol := Round(TACol * 3);   //    BGR (  )
    TACol := (TACol div 3) * 3;  //   
    TACol := Length(ptTrgBGR^[0]) - TACol;
  end;
end;
// ------------------------------------------------------------------------
//   ,   
//   
procedure RotatePointAsVector (var RotateCB : TRotateCB);
begin
  with RotateCB
  do begin
    SYLen := SGRow - RGRow;   // Y -  
    SXLen := SGCol - RGCol;   // X -  
    //  
    GVLen := Sqrt(SXLen * SXLen + SYLen * SYLen);
    //      
    if Abs(GVLen) > 0.1
    then begin
       //     (1)
       SAngl := arcsin(Abs(SYLen)/GVLen);
       if SYLen > 0
       then begin        //  (1)  (2)
          if SXLen > 0
          then SAngl := SAngl          //  (1)
          else SAngl := Pi - SAngl;    //  (2)
       end
       else begin        //  (3)  (4)
          if SXLen > 0
          then SAngl := 2 * Pi- SAngl  //  (4)
          else SAngl := Pi + SAngl;    //  (3)
       end;
       //     
       TAngl := SAngl - Angle;
       //   
       TYLen :=  GVLen * sin(TAngl);
       TXLen :=  GVLen * cos(TAngl);
    end
    else begin
       //      
       SAngl := 0;
       TAngl := 0;
       TYLen := SYLen;
       TXLen := SXLen;
    end;
    //    
    //     
    TGRow := RGRow + TYLen;
    TGCol := RGCol + TXLen;
  end;
end;
// ------------------------------------------------------------------------
//   (    )
function SimpleRotatePoint (var RotateCB : TRotateCB) : boolean;
begin
  Result := False;
  //   (SARow, SACol)   
  //   
  SArrToGeomCord (RotateCB);
  //   ,   
  //   
  RotatePointAsVector (RotateCB);
  //   (TGRow, TGCol)  
  //    
  GeomToArrCord (RotateCB);
  with RotateCB do
    //   (  
    if (TARow >= Low(ptTrgBGR^)) and
       (TARow <= High(ptTrgBGR^))  and
       (TACol >= Low(ptTrgBGR^[0])) and
       (TACol <= High(ptTrgBGR^[0]))
    then Result := True;                 //( )
end;
// ========================================================================
//     BGR- 
// ========================================================================
// 24.02.2013
//    TImgTabBGR    
//  Angle      ptTargetArray
procedure RotateForTabBGR  (ptSourceArray : ptImgTabBGR;
                            RImgRow       : integer;
                            RImgCol       : integer;
                            RqAngle       : extended;
                            RqColor       : TColor;
                            ptTargetArray : ptImgTabBGR;
                            Progress      : TProgressBar);
//
var RotateCB   : TRotateCB;
    PMCol      : integer;
    wBGR       : TBGR;
    wRow, wCol : integer;
begin
   //  
   if Assigned(ptSourceArray) and Assigned(ptTargetArray)
   then begin
      //  
      if  Length(ptSourceArray^) > 2
      then begin
         // ------------------------------
         //     ptTargetArray
         SetAndCrearTabBGR(ptSourceArray,
                           RqColor,
                           ptTargetArray,
                           Progress);
         // ------------------------------
         //      RotateCB 
         RotateCB.ptSrcBGR := ptSourceArray;
         RotateCB.ptTrgBGR := ptTargetArray;
         RotateCB.Angle := RqAngle * Pi / 180;
         //   
         RotateCB.RARow := RImgRow;
         RotateCB.RACol := RImgCol * 3;
         //   (RARow, RACol)   BGR-
         //   
         RArrToGeomCord (RotateCB);
         // ------------------------------
         Progress.Min := 0;
         Progress.Max := Length(ptSourceArray^);
         Progress.Position := Progress.Min;
         // ------------------------------
         try
           for wRow := 0 to High(ptTargetArray^) do
           begin
             //    
             PMCol := Length(ptTargetArray^[wRow]);
             WCol := 0;
             //   
             while WCol < PMCol
             do begin
                //   
                RotateCB.SARow := wRow;
                RotateCB.SACol := wCol;
                //   (    )
                if SimpleRotatePoint (RotateCB)
                then begin
                   with RotateCB
                   do begin
                     //     
                     //   () 
                     wBGR.B := ptSourceArray^[TARow, TACol];     // B
                     wBGR.G := ptSourceArray^[TARow, TACol+1];   // G
                     wBGR.R := ptSourceArray^[TARow, TACol+2];   // R
                     //     
                     ptTargetArray^[wRow, wCol]   := wBGR.B;     // B
                     ptTargetArray^[wRow, wCol+1] := wBGR.G;     // G
                     ptTargetArray^[wRow, wCol+2] := wBGR.R;     // R
                   end;
                end;
                WCol := WCol + 3;     //  BGR - 
             end;
             Progress.Position := Progress.Position + 1;
           end;
         except
            SetLength(ptTargetArray^, 0);
            MessageDlg('RotateForTabBGR :    .',
                        mtWarning, [mbOk], 0);
         end;
         Progress.Position := 0;
      end;
   end;
end;

// ========================================================================
//    BGR- 
// ========================================================================
// 03.03.2013
//    BGR - 
procedure MirrorToTrgArr (ptSrcArr : ptImgTabBGR;
                          Cmd      : char;
                          ptTrgArr : ptImgTabBGR;
                          Progress : TProgressBar);
var SRow   : integer;
    SCol   : integer;
    TRow   : integer;
    TCol   : integer;

begin
   //  
   if not (Assigned(ptSrcArr) and Assigned(ptTrgArr)) then Exit;
   //  
   if Length(ptSrcArr^) < 1 then Exit;
   if Length(ptSrcArr^[0]) < 1 then Exit;
   if not ((Cmd = 'H') or (Cmd = 'V')) then Exit;
   // ,  Warning 
   TRow := 0;  TCol := 0;
   // 
   try
      // ------------------------------
      //     
      SetLength (ptTrgArr^, Length(ptSrcArr^));
      //       
      for SRow := 0 to High(ptSrcArr^)
      do SetLength (ptTrgArr^[SRow], Length(ptSrcArr^[SRow]));
      // ------------------------------
      Progress.Min := 0;
      Progress.Max := Length(ptSrcArr^);
      Progress.Position := Progress.Min;
      // ------------------------------
      //    
      for SRow := 0 to High(ptSrcArr^)
      do begin
         //    
         SCol := 0;
         repeat
            //   TRow, TCol
            case Cmd of
            'H' : begin   //  
                    TRow := SRow;
                    TCol := (Length(ptSrcArr^[SRow])-3) - SCol;
                  end;
            'V' : begin   //  
                    TRow := High(ptSrcArr^) - SRow;
                    TCol := SCol;
                  end;
            end;
            //  
            ptTrgArr^[TRow, TCol]   := ptSrcArr^[SRow, SCol];     // B
            ptTrgArr^[TRow, TCol+1] := ptSrcArr^[SRow, SCol+1];   // G
            ptTrgArr^[TRow, TCol+2] := ptSrcArr^[SRow, SCol+2];   // R
            // BGR -    
            SCol := SCol + 3;
         until (SCol > (Length(ptSrcArr^[SRow]) - 3));
         Progress.Position := Progress.Position + 1;
      end; // for
   except
      SetLength(ptSrcArr^, 0);
      MessageDlg('MirrorToTrgArr :    .',
                        mtWarning, [mbOk], 0);
   end;
   Progress.Position := 0;
end;

// ========================================================================
//    BGR-   90 
// ========================================================================
//        
function Prepare90TrgArr (ptSrcArr : ptImgTabBGR;
                          ptTrgArr : ptImgTabBGR;
                          Progress : TProgressBar) : boolean;
var TRow   : integer;
begin
  Result := False;
  try
    //          
    SetLength(ptTrgArr^, (Length(ptSrcArr^[0]) div 3));
    //         
    for TRow := Low(ptTrgArr^) to High(ptTrgArr^)
    do  SetLength(ptTrgArr^[TRow], (3 * Length(ptSrcArr^)));
    Result := True;
  except
    SetLength(ptTrgArr^, 0);
    MessageDlg('Prepare90TrgArr : '
              + '     .',
              mtWarning, [mbOk], 0);
  end;
end;
// ------------------------------------------------------------------------
// 02.03.2013
//      90 
procedure Rotate90PlusMinus(ptSrcArr : ptImgTabBGR;
                            Cmd      : char;
                            ptTrgArr : ptImgTabBGR;
                            Progress : TProgressBar);
var SRow   : integer;
    SCol   : integer;
    TRow   : integer;
    TCol   : integer;
begin
  //  
  if not (Assigned(ptSrcArr) and Assigned(ptTrgArr)) then Exit;
  //  
  if Length(ptSrcArr^) < 1 then Exit;
  if Length(ptSrcArr^[0]) < 1 then Exit;
  if not ((Cmd = '+') or (Cmd = '-')) then Exit;
  // 
  TRow := 0;  TCol := 0;  // ,  Warning 
  try
     //  
     if not Prepare90TrgArr (ptSrcArr, ptTrgArr, Progress) then Exit;
     // ------------------------------
     Progress.Min := 0;
     Progress.Max := Length(ptSrcArr^);
     Progress.Position := Progress.Min;
     // ------------------------------
      //    
     for SRow := 0 to High(ptSrcArr^)
     do begin
         //    
         SCol := 0;
         repeat
            //   
            case Cmd of
            '+' : begin
                    //    90 
                    TRow := High(ptTrgArr^)- (SCol div 3);
                    TCol := SRow * 3;
                    end;
            '-' : begin
                    //    90 
                    TRow := SCol div 3;
                    Tcol := (High(ptSrcArr^) - SRow)  * 3
                  end;
            end;
            //  
            ptTrgArr^[TRow, TCol]   := ptSrcArr^[SRow, SCol];     // B
            ptTrgArr^[TRow, TCol+1] := ptSrcArr^[SRow, SCol+1];   // G
            ptTrgArr^[TRow, TCol+2] := ptSrcArr^[SRow, SCol+2];   // R
            //  BGR - 
            SCol := SCol + 3;
         until (SCol > Length(ptSrcArr^[SRow]) - 3);
         Progress.Position := Progress.Position + 1;
     end; // for
  except
     SetLength(ptTrgArr^, 0);
     MessageDlg('Rotate90PlusMinus :    .',
                mtWarning, [mbOk], 0);
  end;
end;


// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================

end.
